/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.mapui;

import filenet.vw.api.VWException;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWRouteDefinition;
import filenet.vw.api.VWTextAnnotationDefinition;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.IVWPrintable;
import filenet.vw.toolkit.utils.VWPrinter;
import filenet.vw.toolkit.utils.dialog.VWPrintSetupDialog;
import filenet.vw.toolkit.utils.event.VWToolbarActionNotifier;
import filenet.vw.toolkit.utils.mapui.IVWMapItemsListener;
import filenet.vw.toolkit.utils.mapui.IVWSelectWorkflowItem;
import filenet.vw.toolkit.utils.mapui.VWBaseMapToolbar;
import filenet.vw.toolkit.utils.mapui.VWBaseRouteUI;
import filenet.vw.toolkit.utils.mapui.VWBaseStepUI;
import filenet.vw.toolkit.utils.mapui.VWBaseWorkflowMapPane;
import filenet.vw.toolkit.utils.mapui.VWMap;
import filenet.vw.toolkit.utils.mapui.VWMapAttribs;
import filenet.vw.toolkit.utils.mapui.VWMapCache;
import filenet.vw.toolkit.utils.mapui.VWMapItemsEvent;
import filenet.vw.toolkit.utils.mapui.VWPrintableStepProperty;
import filenet.vw.toolkit.utils.mapui.VWPrintableTextAnnotationProperty;
import filenet.vw.toolkit.utils.mapui.VWPrintableWFProperty;
import filenet.vw.toolkit.utils.mapui.VWWorkflowScrollPane;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.util.Vector;
import javax.swing.JPanel;

public abstract class VWBaseWorkflowPane
extends JPanel
implements ItemListener,
ItemSelectable,
IVWPrintable {
    protected VWBaseMapToolbar m_mapToolbar = null;
    protected VWWorkflowScrollPane m_scrollPane = null;
    protected VWBaseWorkflowMapPane m_activeMapPane = null;
    protected VWMapCache m_mapCache = null;
    protected VWToolbarActionNotifier m_toolbarActionNotifier = null;
    protected VWMapAttribs m_mapAttribs = null;
    protected boolean m_bIsDirty = false;
    protected Vector m_mapItemsListener = new Vector();
    protected ItemListener m_selectListeners = null;
    private boolean m_bNotifyingSelectionListeners = false;
    protected VWWorkflowDefinition m_workflowDefinition = null;
    protected VWWorkflowDefinition m_baseWorkflowDefinition = null;
    protected VWPrinter m_vwPrinter = null;

    public VWBaseWorkflowPane() {
        this.m_mapCache = new VWMapCache();
        this.m_mapAttribs = this.newMapAttributes();
    }

    public void init(VWToolbarActionNotifier toolbarActionNotifier) {
        this.m_toolbarActionNotifier = toolbarActionNotifier;
        this.setLayout(new BorderLayout());
        this.m_mapToolbar = this.newMapToolbar();
        if (this.m_mapToolbar != null) {
            this.m_mapToolbar.init();
            this.add((Component)this.m_mapToolbar, "First");
        }
        this.m_scrollPane = this.newScrollPane();
        if (this.m_scrollPane != null) {
            this.add((Component)this.m_scrollPane, "Center");
        }
    }

    public synchronized void addIVWMapItemsListener(IVWMapItemsListener listener) {
        this.m_mapItemsListener.addElement(listener);
    }

    public synchronized void removeIVWMapItemsListener(IVWMapItemsListener listener) {
        this.m_mapItemsListener.removeElement(listener);
    }

    public boolean getIsDirty() {
        VWMap[] maps = this.m_mapCache.toArray();
        if (maps != null) {
            for (int i = 0; i < maps.length; ++i) {
                if (!maps[i].isMapPaneAvailable() || !maps[i].getMapPane().getIsDirty()) continue;
                return true;
            }
        }
        return false;
    }

    public void setIsDirty(boolean bIsDirty) {
        if (bIsDirty) {
            if (this.m_activeMapPane != null) {
                this.m_activeMapPane.setIsDirty(true);
            }
        } else {
            VWMap[] maps = this.m_mapCache.toArray();
            if (maps != null) {
                for (int i = 0; i < maps.length; ++i) {
                    if (!maps[i].isMapPaneAvailable()) continue;
                    maps[i].getMapPane().setIsDirty(false);
                }
            }
        }
    }

    public void setFocusStep(int nStepId) {
        if (this.m_activeMapPane != null) {
            this.m_activeMapPane.setFocusStep(nStepId);
        }
    }

    public VWBaseWorkflowMapPane getActiveMapPane() {
        return this.m_activeMapPane;
    }

    public VWMapDefinition[] getMapDefinitions() {
        return this.m_mapCache.getMapDefinitions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setWorkflowDefinition(VWWorkflowDefinition workflowDefinition, VWWorkflowDefinition baseWorkflowDefinition) {
        VWBaseWorkflowMapPane mainMapPane2222;
        this.m_workflowDefinition = workflowDefinition;
        this.m_baseWorkflowDefinition = baseWorkflowDefinition;
        this.m_scrollPane.getViewport().removeAll();
        this.m_mapCache.reset();
        this.m_activeMapPane = null;
        Vector<String> mapNames = new Vector<String>();
        VWMap mainMap = null;
        try {
            try {
                VWMapDefinition[] baseMaps;
                VWMap map;
                int i;
                VWMapDefinition[] maps;
                if (this.m_workflowDefinition != null && (maps = this.m_workflowDefinition.getMaps()) != null) {
                    for (i = 0; i < maps.length; ++i) {
                        VWMapDefinition mapDef = maps[i];
                        if (mapDef == null) continue;
                        map = new VWMap(this, mapDef);
                        this.m_mapCache.addCurrentMap(map);
                        mapNames.add(mapDef.getName());
                        if (mainMap != null || !map.isMainMap()) continue;
                        mainMap = map;
                    }
                }
                if (this.m_baseWorkflowDefinition != null && (baseMaps = this.m_baseWorkflowDefinition.getMaps()) != null) {
                    for (i = 0; i < baseMaps.length; ++i) {
                        VWMapDefinition baseMap = baseMaps[i];
                        if (baseMap == null) continue;
                        map = new VWMap(this, baseMap);
                        this.m_mapCache.addBaseMap(map);
                        if (mainMap != null || !map.isMainMap()) continue;
                        mainMap = map;
                    }
                }
                Object var10_10 = null;
            }
            catch (VWException ex) {
                VWBaseWorkflowMapPane mainMapPane2222;
                VWDebug.logException(ex);
                Object var10_11 = null;
                this.setVisible(false);
                this.updateUI();
                this.setVisible(true);
                this.m_mapToolbar.initMapCombo(this.m_mapCache.toVector());
                if (mainMap != null && (mainMapPane2222 = mainMap.getMapPane()) != null) {
                    this.setActiveMapPane(mainMapPane2222);
                }
                mapNames.removeAllElements();
                return;
            }
        }
        catch (Throwable throwable) {
            VWBaseWorkflowMapPane mainMapPane2222;
            Object var10_12 = null;
            this.setVisible(false);
            this.updateUI();
            this.setVisible(true);
            this.m_mapToolbar.initMapCombo(this.m_mapCache.toVector());
            if (mainMap != null && (mainMapPane2222 = mainMap.getMapPane()) != null) {
                this.setActiveMapPane(mainMapPane2222);
            }
            mapNames.removeAllElements();
            mapNames = null;
            throw throwable;
        }
        this.setVisible(false);
        this.updateUI();
        this.setVisible(true);
        this.m_mapToolbar.initMapCombo(this.m_mapCache.toVector());
        if (mainMap != null && (mainMapPane2222 = mainMap.getMapPane()) != null) {
            this.setActiveMapPane(mainMapPane2222);
        }
        mapNames.removeAllElements();
    }

    public void displayMap(Object obj) {
        if (obj != null && obj instanceof VWMap) {
            VWMap map = (VWMap)obj;
            this.setActiveMapPane(map.getMapPane());
        }
    }

    public void displayMap(String mapName) {
        this.setActiveMapPane(this.findMap(mapName).getMapPane());
    }

    public void selectMapFromMapCombo(String mapName) {
        VWMap map = this.findMap(mapName);
        if (map != null) {
            if (this.m_mapToolbar != null) {
                this.m_mapToolbar.selectMap(map);
            } else {
                this.setActiveMapPane(this.findMap(mapName).getMapPane());
            }
        }
    }

    public void selectMap(String mapName) {
        this.selectMapFromMapCombo(mapName);
    }

    public VWBaseMapToolbar getMapToolbar() {
        return this.m_mapToolbar;
    }

    public VWMapCache getMapCache() {
        return this.m_mapCache;
    }

    public VWToolbarActionNotifier getToolbarActionNotifier() {
        return this.m_toolbarActionNotifier;
    }

    public VWMapAttribs getMapAttributes() {
        return this.m_mapAttribs;
    }

    public void updateStepUI() {
        if (this.m_activeMapPane != null) {
            this.m_activeMapPane.updateStepUI();
        }
    }

    public void updateRouteUI() {
        if (this.m_activeMapPane != null) {
            this.m_activeMapPane.updateRouteUI();
        }
    }

    public void updateTextAnnotationUI() {
        if (this.m_activeMapPane != null) {
            this.m_activeMapPane.updateTextAnnotationUI();
        }
    }

    public void itemStateChanged(ItemEvent event) {
        if (this.m_bNotifyingSelectionListeners) {
            return;
        }
        if (this.m_activeMapPane != null) {
            this.m_activeMapPane.itemStateChanged(event);
        }
    }

    public synchronized void addItemListener(ItemListener listener) {
        this.m_selectListeners = AWTEventMulticaster.add(this.m_selectListeners, listener);
    }

    public Object[] getSelectedObjects() {
        if (this.m_activeMapPane != null) {
            return this.m_activeMapPane.getSelectedObjects();
        }
        return null;
    }

    public synchronized void removeItemListener(ItemListener listener) {
        this.m_selectListeners = AWTEventMulticaster.remove(this.m_selectListeners, listener);
    }

    public int calculateMapPageCount(PageFormat pf) {
        int totalMapPages = 0;
        VWBaseWorkflowMapPane[] mapPanes = this.m_mapCache.getMapPanes();
        if (mapPanes != null) {
            for (int i = 0; i < mapPanes.length; ++i) {
                totalMapPages += mapPanes[i].calculateMapPageCount(pf);
            }
        }
        return totalMapPages;
    }

    public int print(Graphics g1, PageFormat pf, int pi) throws PrinterException {
        return 1;
    }

    public void bindBook() {
        try {
            Graphics theGraphics = this.m_activeMapPane.getGraphics();
            if (this.m_mapAttribs.isPrintWflProperty()) {
                VWPrintableWFProperty wfPrintable = this.getPrintableWFProperty(theGraphics);
                wfPrintable.setupVWPrinter(this.m_vwPrinter);
                wfPrintable.bindBook();
            }
            if (this.m_mapAttribs.isPrintAll()) {
                VWBaseWorkflowMapPane[] mapPanes;
                VWBaseWorkflowMapPane mainMap = this.m_mapCache.getMapPane("Workflow");
                if (mainMap != null) {
                    if (this.m_mapAttribs.isPrintMap()) {
                        mainMap.bindBook(this.m_vwPrinter, theGraphics);
                    }
                    if (this.m_mapAttribs.isPrintStepRouteProperty()) {
                        this.bindStepRouteProperty(mainMap, theGraphics);
                    }
                    if (this.m_mapAttribs.isPrintTextAnnotationProperties()) {
                        this.bindTextAnnotationProperties(mainMap, theGraphics);
                    }
                }
                if ((mapPanes = this.m_mapCache.getMapPanes()) != null) {
                    for (int i = 0; i < mapPanes.length; ++i) {
                        String mapName;
                        if (mapPanes[i] == null || (mapName = mapPanes[i].getMapName()) != null && mapName.compareTo("Workflow") == 0) continue;
                        if (this.m_mapAttribs.isPrintMap()) {
                            mapPanes[i].bindBook(this.m_vwPrinter, theGraphics);
                        }
                        if (this.m_mapAttribs.isPrintStepRouteProperty()) {
                            this.bindStepRouteProperty(mapPanes[i], theGraphics);
                        }
                        if (!this.m_mapAttribs.isPrintTextAnnotationProperties()) continue;
                        this.bindTextAnnotationProperties(mapPanes[i], theGraphics);
                    }
                }
            } else {
                if (this.m_mapAttribs.isPrintMap()) {
                    this.m_activeMapPane.bindBook(this.m_vwPrinter, theGraphics);
                }
                if (this.m_mapAttribs.isPrintStepRouteProperty()) {
                    this.bindStepRouteProperty(this.m_activeMapPane, theGraphics);
                }
                if (this.m_mapAttribs.isPrintTextAnnotationProperties()) {
                    this.bindTextAnnotationProperties(this.m_activeMapPane, theGraphics);
                }
            }
        }
        catch (Exception e) {
            VWDebug.logException(e);
        }
    }

    public void printSetup() {
        try {
            PageFormat pf = this.m_vwPrinter.getPageFormat();
            VWPrintSetupDialog printSetupDialog = new VWPrintSetupDialog(this.m_vwPrinter);
            printSetupDialog.init(this.m_mapAttribs);
            printSetupDialog.setVisible(true);
            if (printSetupDialog.returnStatus() == 0) {
                boolean bUpdateMapPane = false;
                if (printSetupDialog.getPageFormat() != pf) {
                    this.m_vwPrinter.setPageFormat(printSetupDialog.getPageFormat());
                    bUpdateMapPane = true;
                }
                if (bUpdateMapPane) {
                    this.updateUI();
                }
            }
        }
        catch (Exception e) {
            VWDebug.logException(e);
        }
    }

    public void setupVWPrinter(VWPrinter printer) {
        this.m_vwPrinter = printer;
    }

    public VWPrinter getVWPrinter() {
        return this.m_vwPrinter;
    }

    protected abstract VWBaseMapToolbar newMapToolbar();

    protected abstract VWBaseWorkflowMapPane newMapPane();

    protected abstract VWWorkflowScrollPane newScrollPane();

    protected abstract VWMapAttribs newMapAttributes();

    protected void notifyOfItemsAdded(VWMapItemsEvent event) {
        if (this.m_mapItemsListener.size() > 0) {
            for (int index = 0; index < this.m_mapItemsListener.size(); ++index) {
                ((IVWMapItemsListener)this.m_mapItemsListener.elementAt(index)).itemsAdded(event);
            }
        }
    }

    protected void notifyOfItemsRemoved(VWMapItemsEvent event) {
        if (this.m_mapItemsListener.size() > 0) {
            for (int index = 0; index < this.m_mapItemsListener.size(); ++index) {
                ((IVWMapItemsListener)this.m_mapItemsListener.elementAt(index)).itemsRemoved(event);
            }
        }
    }

    protected boolean clearAllSelectedItems(boolean bNotify) {
        if (this.m_activeMapPane != null) {
            return this.m_activeMapPane.clearAllSelectedItems(bNotify);
        }
        return false;
    }

    protected VWBaseStepUI findStep(VWMapNode mapNode) {
        if (this.m_activeMapPane != null) {
            return this.m_activeMapPane.findStep(mapNode);
        }
        return null;
    }

    protected VWBaseRouteUI findRoute(VWRouteDefinition vwRoute) {
        if (this.m_activeMapPane != null) {
            return this.m_activeMapPane.findRoute(vwRoute);
        }
        return null;
    }

    protected Vector getAllSelectedItems() {
        if (this.m_activeMapPane != null) {
            return this.m_activeMapPane.getAllSelectedItems();
        }
        return null;
    }

    protected IVWSelectWorkflowItem getItemWithFocus() {
        if (this.m_activeMapPane != null) {
            return this.m_activeMapPane.getItemWithFocus();
        }
        return null;
    }

    protected void invalidStepRegion(VWBaseStepUI step) {
        if (this.m_activeMapPane != null) {
            this.m_activeMapPane.invalidStepRegion(step);
        }
    }

    protected synchronized void notifySelectListeners(ItemEvent event) {
        if (this.m_selectListeners != null) {
            this.m_bNotifyingSelectionListeners = true;
            this.m_selectListeners.itemStateChanged(event);
            this.m_bNotifyingSelectionListeners = false;
        }
    }

    protected void setActiveMapPane(VWBaseWorkflowMapPane mapPane) {
        if (mapPane == null) {
            return;
        }
        if (this.m_activeMapPane != null) {
            this.m_activeMapPane.setVisible(false);
            this.m_scrollPane.getViewport().removeAll();
        }
        mapPane.setVisible(true);
        this.m_activeMapPane = mapPane;
        this.m_scrollPane.getViewport().add(mapPane);
        mapPane.activated();
    }

    protected VWMap findMap(String mapName) {
        return this.m_mapCache.get(mapName, true);
    }

    protected VWBaseWorkflowMapPane createMapPane(VWMap map) {
        VWBaseWorkflowMapPane mapPane = this.newMapPane();
        if (mapPane != null) {
            mapPane.setVisible(false);
            mapPane.setMapDefinition(map);
        }
        return mapPane;
    }

    protected void removeReferences() {
        if (this.m_mapToolbar != null) {
            this.m_mapToolbar.removeReferences();
            this.m_mapToolbar = null;
        }
        if (this.m_scrollPane != null) {
            this.m_scrollPane.removeReferences();
            this.m_scrollPane = null;
        }
        if (this.m_mapItemsListener != null) {
            this.m_mapItemsListener.removeAllElements();
            this.m_mapItemsListener = null;
        }
        if (this.m_toolbarActionNotifier != null) {
            this.m_toolbarActionNotifier.releaseReferences();
            this.m_toolbarActionNotifier = null;
        }
        this.m_selectListeners = null;
        this.m_workflowDefinition = null;
        if (this.m_mapCache != null) {
            this.m_mapCache.reset();
            this.m_mapCache = null;
        }
        this.m_activeMapPane = null;
        this.m_vwPrinter = null;
        if (this.m_mapAttribs != null) {
            this.m_mapAttribs.removeReferences();
            this.m_mapAttribs = null;
        }
        this.removeAll();
    }

    protected VWPrintableWFProperty getPrintableWFProperty(Graphics theGraphics) {
        return new VWPrintableWFProperty(this.m_mapCache, this.m_workflowDefinition, theGraphics, true);
    }

    protected void bindStepRouteProperty(VWBaseWorkflowMapPane mapPane, Graphics g) throws Exception {
        String activeMapName = mapPane.getMapName();
        VWMapDefinition currentMapDef = this.m_mapCache.getMapDefinition(activeMapName);
        VWMapNode[] nodeList = currentMapDef.getSteps();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.length; ++i) {
                VWPrintableStepProperty stepPrintable = new VWPrintableStepProperty(nodeList[i], g, mapPane.m_map, this.m_vwPrinter, true);
                stepPrintable.bindBook();
            }
        }
    }

    protected void bindTextAnnotationProperties(VWBaseWorkflowMapPane mapPane, Graphics g) throws Exception {
        String activeMapName = mapPane.getMapName();
        VWMapDefinition currentMapDef = this.m_mapCache.getMapDefinition(activeMapName);
        VWTextAnnotationDefinition[] textAnnotations = currentMapDef.getTextAnnotations();
        if (textAnnotations != null) {
            for (int i = 0; i < textAnnotations.length; ++i) {
                VWPrintableTextAnnotationProperty textAnnotationPrintable = new VWPrintableTextAnnotationProperty(textAnnotations[i], g, this.m_vwPrinter);
                textAnnotationPrintable.bindBook();
            }
        }
    }
}

